#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=232292 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 09:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 09:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 09:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 12:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 12:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 12:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 12:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 12:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 12:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (209999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 19:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 19:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 19:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 19:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 19:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 19:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 23:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 23:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 23:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-20 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-20 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-20 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210323, 'Database Backup [database_backup_2025-02-21-00-04-02-v3-1-6.zip]', '2025-02-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 09:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 09:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 09:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (210999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211011, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-21 21:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211012, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-02-21 21:01:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 21:01:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 21:01:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 21:01:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-21 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-21 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-21 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211121, 'Database Backup [database_backup_2025-02-22-00-04-03-v3-1-6.zip]', '2025-02-22 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 09:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 09:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 09:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 10:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 10:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 10:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 14:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 14:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 14:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 14:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 14:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 14:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 18:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 18:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 18:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211827, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-22 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 21:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 21:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 21:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211831, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-02-22 21:03:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211835, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-02-22 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211839, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-02-22 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211843, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-02-22 21:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211847, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-02-22 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-22 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-22 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-22 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211938, 'Database Backup [database_backup_2025-02-23-00-01-02-v3-1-6.zip]', '2025-02-23 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (211999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 05:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 05:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 05:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 09:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 09:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 09:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 13:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 13:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 13:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 16:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 16:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 16:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 19:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 19:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 19:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 21:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 21:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 21:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-23 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-23 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-23 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212773, 'Database Backup [database_backup_2025-02-24-00-04-03-v3-1-6.zip]', '2025-02-24 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 03:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 03:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 03:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (212999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 12:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 12:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 12:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 19:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 19:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 19:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213476, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-24 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213477, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-02-24 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-24 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-24 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-24 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213580, 'Database Backup [database_backup_2025-02-25-00-00-06-v3-1-6.zip]', '2025-02-25 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 1