#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=257790 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (232999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233022, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-20 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233023, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-20 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233024, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233028, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-20 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-20 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-20 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233137, 'Database Backup [database_backup_2025-03-21-00-04-03-v3-1-6.zip]', '2025-03-21 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233855, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-21 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-21 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-21 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-21 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233961, 'Database Backup [database_backup_2025-03-22-00-03-03-v3-1-6.zip]', '2025-03-22 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (233999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 12:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 12:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 12:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 18:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 18:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 18:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-22 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-22 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-22 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234766, 'Database Backup [database_backup_2025-03-23-00-05-02-v3-1-6.zip]', '2025-03-23 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (234999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 07:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 07:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 07:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 17:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 20:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235472, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-23 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235473, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-03-23 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 22:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 22:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 22:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-23 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-23 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-23 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235573, 'Database Backup [database_backup_2025-03-24-00-00-03-v3-1-6.zip]', '2025-03-24 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 00:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 00:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 00:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 03:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 03:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 03:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 08:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 08:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 08:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (235999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 14:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 14:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 14:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 17:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 17:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 17:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 17:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236273, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-24 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-24 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-24 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-24 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236376, 'Database Backup [database_backup_2025-03-25-00-03-03-v3-1-6.zip]', '2025-03-25 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 01:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 01:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 01:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (2368