#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=251184 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (225999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226442, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-12 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-12 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-12 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-12 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226551, 'Database Backup [database_backup_2025-03-13-00-03-03-v3-1-6.zip]', '2025-03-13 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (226999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227380, 'Database Backup [database_backup_2025-03-14-00-05-03-v3-1-6.zip]', '2025-03-14 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 14:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 14:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 14:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 15:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 15:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 15:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (227999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 20:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 20:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 20:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 20:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 20:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228095, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-14 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228096, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-03-14 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-14 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-14 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-14 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228202, 'Database Backup [database_backup_2025-03-15-00-04-03-v3-1-6.zip]', '2025-03-15 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 01:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 01:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 01:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 14:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 14:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 14:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 20:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 20:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 20:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228896, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-15 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-15 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-15 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-15 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (228999, 'Database Backup [database_backup_2025-03-16-00-00-03-v3-1-6.zip]', '2025-03-16 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 02:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 04:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 04:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 04:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 16:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 16:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 16:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 17:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 17:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 17:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 19:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 19:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 19:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 21:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 21:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 21:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-16 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-16 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-16 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229807, 'Database Backup [database_backup_2025-03-17-00-00-04-v3-1-6.zip]', '2025-03-17 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 03:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 03:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 03:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (229999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-17 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-17 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (230301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-17 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `descrip