#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=363179 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350304, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-11 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350305, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-08-11 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350306, 'Invoice Status Updated [Invoice Number: INV-184/08/2025, From: Unpaid To: Overdue]', '2025-08-11 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350307, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-08-11 21:02:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350308, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-08-11 21:02:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:02:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:02:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:02:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350405, 'Database Backup [database_backup_2025-08-12-00-00-03-v3-3-1.zip]', '2025-08-12 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350556, 'Non Existing User Tried to Login [Email: tishara.f@successlaunchkit.com, Is Staff Member: No, IP: 2803:1500:1c00:a4e7:3c3a:55ab:f8ca:b8cb]', '2025-08-12 04:58:59', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350560, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:a4e7:3c3a:55ab:f8ca:b8cb]', '2025-08-12 04:59:16', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350561, 'Non Existing User Tried to Login [Email: tishara.f@saylessdigital.io, Is Staff Member: No, IP: 2803:1500:1c00:a4e7:3c3a:55ab:f8ca:b8cb]', '2025-08-12 05:00:56', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350562, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:153b:fa95:b7bc:3f83]', '2025-08-12 05:02:32', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350563, 'Failed Login Attempt [Email: tishara.f@saylesstt.com, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:3c3a:55ab:f8ca:b8cb]', '2025-08-12 05:03:32', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350564, 'Failed Login Attempt [Email: tishara.f@saylesstt.com, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:3c3a:55ab:f8ca:b8cb]', '2025-08-12 05:04:04', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350568, 'Staff Password Changed [3]', '2025-08-12 05:05:29', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350569, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:3c3a:55ab:f8ca:b8cb]', '2025-08-12 05:06:05', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350573, 'New Expense Category Added [ID: 8]', '2025-08-12 05:10:13', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350574, 'New Expense Added [15]', '2025-08-12 05:10:30', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350575, 'New Expense Added [16]', '2025-08-12 05:10:55', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350576, 'New Expense Category Added [ID: 9]', '2025-08-12 05:11:26', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350577, 'New Expense Added [17]', '2025-08-12 05:11:34', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350578, 'New Expense Category Added [ID: 10]', '2025-08-12 05:13:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350579, 'New Expense Added [18]', '2025-08-12 05:13:21', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350589, 'New Expense Category Added [ID: 11]', '2025-08-12 05:29:43', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350590, 'New Expense Added [19]', '2025-08-12 05:30:24', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350591, 'New Expense Added [20]', '2025-08-12 05:30:49', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350592, 'Expense Deleted [20]', '2025-08-12 05:32:36', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350596, 'Expense Updated [18]', '2025-08-12 05:37:09', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350600, 'Invoice Status Updated [Invoice Number: INV-177/07/2025, From: Overdue To: Paid]', '2025-08-12 05:44:38', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350601, 'Payment Recorded [ID:134, Invoice Number: INV-177/07/2025, Total: 2,520.00$]', '2025-08-12 05:44:38', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350602, 'Email Sent To [Email: dallas.f@saylessdigital.io, Template: Invoice Payment Recorded (Sent to Staff)]', '2025-08-12 05:44:41', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350603, 'Payment Recorded [ID:135, Invoice Number: INV-177/07/2025, Total: 2,520.00$]', '2025-08-12 05:44:48', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350604, 'Email Sent To [Email: dallas.f@saylessdigital.io, Template: Invoice Payment Recorded (Sent to Staff)]', '2025-08-12 05:44:50', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350608, 'Payment Deleted [ID:135, Invoice Number: ]', '2025-08-12 05:45:50', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350609, 'Payment Updated [Number:134]', '2025-08-12 05:47:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350610, 'Payment Updated [Number:134]', '2025-08-12 05:48:08', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350614, 'Customer Status Changed [ID: 38 Status(Active/Inactive): 0]', '2025-08-12 05:51:02', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350615, 'Customer Status Changed [ID: 100 Status(Active/Inactive): 0]', '2025-08-12 05:52:14', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350616, 'Customer Status Changed [ID: 78 Status(Active/Inactive): 0]', '2025-08-12 05:55:33', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350617, 'Customer Status Changed [ID: 91 Status(Active/Inactive): 0]', '2025-08-12 05:55:36', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350621, 'Customer Status Changed [ID: 66 Status(Active/Inactive): 0]', '2025-08-12 05:56:56', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350622, 'Customer Status Changed [ID: 7 Status(Active/Inactive): 0]', '2025-08-12 05:57:05', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350623, 'Customer Status Changed [ID: 92 Status(Active/Inactive): 0]', '2025-08-12 05:57:13', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350624, 'Customer Status Changed [ID: 23 Status(Active/Inactive): 0]', '2025-08-12 05:57:20', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350625, 'Customer Status Changed [ID: 88 Status(Active/Inactive): 0]', '2025-08-12 05:57:23', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350626, 'Customer Status Changed [ID: 22 Status(Active/Inactive): 0]', '2025-08-12 05:57:28', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350627, 'Customer Status Changed [ID: 50 Status(Active/Inactive): 0]', '2025-08-12 05:57:32', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350628, 'Customer Status Changed [ID: 95 Status(Active/Inactive): 0]', '2025-08-12 05:57:33', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350629, 'Customer Status Changed [ID: 3 Status(Active/Inactive): 0]', '2025-08-12 05:57:34', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350630, 'Customer Status Changed [ID: 85 Status(Active/Inactive): 0]', '2025-08-12 05:57:43', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350631, 'Customer Status Changed [ID: 15 Status(Active/Inactive): 0]', '2025-08-12 05:57:56', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350632, 'Customer Status Changed [ID: 65 Status(Active/Inactive): 0]', '2025-08-12 05:57:58', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350633, 'Customer Status Changed [ID: 83 Status(Active/Inactive): 0]', '2025-08-12 05:57:59', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350634, 'Customer Status Changed [ID: 83 Status(Active/Inactive): 1]', '2025-08-12 05:58:06', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350635, 'Customer Status Changed [ID: 18 Status(Active/Inactive): 0]', '2025-08-12 05:58:11', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350636, 'Customer Status Changed [ID: 97 Status(Active/Inactive): 0]', '2025-08-12 05:58:17', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350637, 'Customer Status Changed [ID: 94 Status(Active/Inactive): 0]', '2025-08-12 05:58:18', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350638, 'Customer Status Changed [ID: 9 Status(Active/Inactive): 0]', '2025-08-12 05:58:26', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350639, 'Customer Status Changed [ID: 79 Status(Active/Inactive): 0]', '2025-08-12 05:58:27', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350640, 'Customer Status Changed [ID: 5 Status(Active/Inactive): 0]', '2025-08-12 05:58:28', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350641, 'Customer Status Changed [ID: 96 Status(Active/Inactive): 0]', '2025-08-12 05:58:37', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350642, 'Customer Status Changed [ID: 98 Status(Active/Inactive): 0]', '2025-08-12 05:58:38', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350643, 'Customer Status Changed [ID: 47 Status(Active/Inactive): 0]', '2025-08-12 05:58:50', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350644, 'Customer Status Changed [ID: 87 Status(Active/Inactive): 0]', '2025-08-12 05:58:53', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350645, 'Customer Status Changed [ID: 21 Status(Active/Inactive): 0]', '2025-08-12 05:58:54', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350646, 'Customer Status Changed [ID: 99 Status(Active/Inactive): 0]', '2025-08-12 05:58:57', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350647, 'Customer Status Changed [ID: 80 Status(Active/Inactive): 0]', '2025-08-12 05:59:02', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350648, 'Customer Status Changed [ID: 80 Status(Active/Inactive): 1]', '2025-08-12 05:59:06', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350649, 'Customer Status Changed [ID: 10 Status(Active/Inactive): 0]', '2025-08-12 05:59:09', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350650, 'Customer Status Changed [ID: 31 Status(Active/Inactive): 0]', '2025-08-12 05:59:15', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350651, 'Customer Status Changed [ID: 48 Status(Active/Inactive): 0]', '2025-08-12 05:59:20', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350655, 'Customer Status Changed [ID: 80 Status(Active/Inactive): 0]', '2025-08-12 06:02:14', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350662, 'New Leads Status Added [StatusID: 71, Name: SLK Customer]', '2025-08-12 06:15:13', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350663, 'New Leads Source Added [SourceID: 10, Name: Tik Tok]', '2025-08-12 06:15:15', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350664, 'New Lead Added [ID: 624]', '2025-08-12 06:15:33', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350665, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: New Contact Added/Registered (Welcome Email)]', '2025-08-12 06:17:13', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350666, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Set New Password]', '2025-08-12 06:17:13', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350667, 'Contact Created [ID: 113]', '2025-08-12 06:17:13', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350668, 'New Client Created [ID: 104, From Staff: 3]', '2025-08-12 06:17:13', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350669, 'Created Lead Client Profile [LeadID: 624, ClientID: 104]', '2025-08-12 06:17:13', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350670, 'New Invoice Item Added [ID:18, SLK Membership Fee]', '2025-08-12 06:18:36', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 17:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 17:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 17:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351124, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-12 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351125, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-08-12 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351126, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-08-12 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351127, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Send Invoice to Customer]', '2025-08-12 21:00:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351128, 'Email sent to: tishara.f@saylesstt.com Subject: Recurring Invoices Cron Job Activity', '2025-08-12 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351129, 'Email sent to: clientportal@saylesstt.com Subject: Recurring Invoices Cron Job Activity', '2025-08-12 21:00:26', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351130, 'Email sent to: dallas.f@saylessdigital.io Subject: Recurring Invoices Cron Job Activity', '2025-08-12 21:00:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 21:00:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 21:00:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 21:00:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351227, 'Database Backup [database_backup_2025-08-13-00-02-03-v3-3-1.zip]', '2025-08-13 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 00:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 00:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 00:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351678, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:153b:fa95:b7bc:3f83]', '2025-08-13 14:29:29', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351979, 'Database Backup [database_backup_2025-08-14-00-05-02-v3-3-1.zip]', '2025-08-14 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:57:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:57:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:57:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:31:42', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:31:42', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:31:42', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352187, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:153b:fa95:b7bc:3f83]', '2025-08-14 07:08:02', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352188, 'Invoice Status Updated [Invoice Number: INV-184/08/2025, From: Overdue To: Paid]', '2025-08-14 07:10:16', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352189, 'Payment Recorded [ID:136, Invoice Number: INV-184/08/2025, Total: $350.00]', '2025-08-14 07:10:16', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352190, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-08-14 07:10:22', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352191, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-08-14 07:10:25', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352504, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:153b:fa95:b7bc:3f83]', '2025-08-14 17:14:59', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352622, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-14 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352623, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-08-14 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352720, 'Database Backup [database_backup_2025-08-15-00-00-42-v3-3-1.zip]', '2025-08-15 00:00:42', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:41:53', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:41:53', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:41:53', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353369, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-15 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353370, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-08-15 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353371, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-08-15 21:02:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353372, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Due Notice]', '2025-08-15 21:02:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353373, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Due Notice]', '2025-08-15 21:02:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:02:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:02:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:02:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353470, 'Database Backup [database_backup_2025-08-16-00-01-03-v3-3-1.zip]', '2025-08-16 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354026, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:8c5:89df:d52a:f69f:965a]', '2025-08-29 19:30:14', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354027, 'Cron Invoked Manually', '2025-08-29 19:31:59', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354028, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:03', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354029, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:07', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354030, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:11', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354031, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:15', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354032, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354033, 'Invoice Status Updated [Invoice Number: INV-185/08/2025, From: Unpaid To: Overdue]', '2025-08-29 19:32:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354034, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-08-29 19:32:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354035, 'Invoice Status Updated [Invoice Number: INV-186/08/2025, From: Unpaid To: Overdue]', '2025-08-29 19:32:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354036, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:25', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354037, 'Invoice Status Updated [Invoice Number: INV-187/08/2025, From: Unpaid To: Overdue]', '2025-08-29 19:32:25', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354038, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:29', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354039, 'Invoice Status Updated [Invoice Number: INV-188/08/2025, From: Unpaid To: Overdue]', '2025-08-29 19:32:29', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354040, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 19:32:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 19:32:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 19:32:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354044, 'Database Backup [database_backup_2025-08-29-19-32-33-v3-3-1.zip]', '2025-08-29 19:32:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354045, 'Invoice Status Updated [Invoice Number: INV-178/07/2025, From: Overdue To: Paid]', '2025-08-29 19:36:13', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354046, 'Payment Recorded [ID:137, Invoice Number: INV-178/07/2025, Total: $500.00]', '2025-08-29 19:36:13', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354047, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-08-29 19:36:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt