#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=127540 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (102999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103054, 'Payment Recorded [ID:117, Invoice Number: INV-133/05/2024, Total: $5,295.00]', '2024-10-09 06:14:43', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103055, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-10-09 06:14:48', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103266, 'Invoice Status Updated [Invoice Number: INV-163/10/2024, From: Unpaid To: Paid]', '2024-10-09 12:43:09', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103267, 'Payment Recorded [ID:118, Invoice Number: INV-163/10/2024, Total: $999.00]', '2024-10-09 12:43:09', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103268, 'Email Sent To [Email: marc@apangsmarketing.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-10-09 12:43:25', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 15:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 15:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 15:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103542, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-10-09 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 21:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 21:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 21:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 21:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 21:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 21:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-09 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-09 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-09 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103645, 'Database Backup [database_backup_2024-10-10-00-04-02-v3-1-6.zip]', '2024-10-10 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 09:18:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 09:18:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 09:18:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 09:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 09:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 09:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (103999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 11:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 11:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 11:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 15:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 15:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 15:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 17:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 17:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 17:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 18:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 18:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 18:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 19:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 19:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 19:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 21:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 21:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 21:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-10 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-10 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-10 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104429, 'Database Backup [database_backup_2024-10-11-00-01-02-v3-1-6.zip]', '2024-10-11 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 00:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 00:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 00:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 02:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 02:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 02:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 02:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 02:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 02:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 04:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 04:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 04:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 05:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 05:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 05:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 06:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 06:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 06:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 11:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 11:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 11:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 13:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 13:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 13:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 14:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 14:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 14:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 16:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 16:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 16:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (104999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 17:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 17:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 17:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 21:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 21:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 21:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 21:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 21:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 21:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-11 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-11 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-11 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105228, 'Database Backup [database_backup_2024-10-12-00-05-02-v3-1-6.zip]', '2024-10-12 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 04:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 04:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 04:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 06:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 06:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 06:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 07:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 07:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 07:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 07:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 07:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 07:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 08:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 08:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 08:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 10:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 10:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 10:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 14:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 14:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 14:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 18:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 18:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 18:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105919, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-10-12 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 23:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 23:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 23:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (105999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-12 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-12 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-12 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106019, 'Database Backup [database_backup_2024-10-13-00-02-02-v3-1-6.zip]', '2024-10-13 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 00:36:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 00:36:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 00:36:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 01:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 01:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 01:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 02:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 02:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 02:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 03:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 03:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 03:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 03:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 04:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 04:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 04:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 08:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 08:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 08:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 09:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 09:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 09:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 10:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 10:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 10:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 10:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 10:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 10:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 11:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 11:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 11:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 14:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 14:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 14:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 16:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 16:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 16:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 16:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 16:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 16:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 17:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 17:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 17:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 18:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 18:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 18:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 21:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 21:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 21:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 23:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 23:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 23:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-13 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-13 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-13 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106812, 'Database Backup [database_backup_2024-10-14-00-00-04-v3-1-6.zip]', '2024-10-14 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106828, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.190]', '2024-10-14 00:32:18', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 02:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 02:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 02:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 02:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 02:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 02:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 04:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 04:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 04:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 04:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 04:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 04:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 05:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (106999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 07:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 07:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 07:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 08:04:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 08:04:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 08:04:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 10:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 10:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 10:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 11:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 11:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 11:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 12:08:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 12:08:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 12:08:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 12:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 12:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 12:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 14:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 14:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 14:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 15:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 15:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 15:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-14 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-14 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (107423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-14 18:31: