#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=364674 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351678, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:153b:fa95:b7bc:3f83]', '2025-08-13 14:29:29', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351979, 'Database Backup [database_backup_2025-08-14-00-05-02-v3-3-1.zip]', '2025-08-14 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (351999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 01:57:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 01:57:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 01:57:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:31:42', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:31:42', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:31:42', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352187, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:153b:fa95:b7bc:3f83]', '2025-08-14 07:08:02', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352188, 'Invoice Status Updated [Invoice Number: INV-184/08/2025, From: Overdue To: Paid]', '2025-08-14 07:10:16', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352189, 'Payment Recorded [ID:136, Invoice Number: INV-184/08/2025, Total: $350.00]', '2025-08-14 07:10:16', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352190, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-08-14 07:10:22', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352191, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-08-14 07:10:25', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352504, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:153b:fa95:b7bc:3f83]', '2025-08-14 17:14:59', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 19:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 19:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 19:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352622, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-14 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352623, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-08-14 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-14 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-14 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-14 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352720, 'Database Backup [database_backup_2025-08-15-00-00-42-v3-3-1.zip]', '2025-08-15 00:00:42', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (352999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:41:53', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:41:53', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:41:53', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353369, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-15 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353370, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-08-15 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353371, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-08-15 21:02:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353372, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Due Notice]', '2025-08-15 21:02:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353373, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Due Notice]', '2025-08-15 21:02:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:02:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:02:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:02:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-15 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-15 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-15 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353470, 'Database Backup [database_backup_2025-08-16-00-01-03-v3-3-1.zip]', '2025-08-16 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (353999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-16 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-16 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-16 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354026, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:8c5:89df:d52a:f69f:965a]', '2025-08-29 19:30:14', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354027, 'Cron Invoked Manually', '2025-08-29 19:31:59', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354028, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:03', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354029, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:07', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354030, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:11', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354031, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:15', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354032, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354033, 'Invoice Status Updated [Invoice Number: INV-185/08/2025, From: Unpaid To: Overdue]', '2025-08-29 19:32:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354034, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-08-29 19:32:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354035, 'Invoice Status Updated [Invoice Number: INV-186/08/2025, From: Unpaid To: Overdue]', '2025-08-29 19:32:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354036, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:25', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354037, 'Invoice Status Updated [Invoice Number: INV-187/08/2025, From: Unpaid To: Overdue]', '2025-08-29 19:32:25', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354038, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:29', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354039, 'Invoice Status Updated [Invoice Number: INV-188/08/2025, From: Unpaid To: Overdue]', '2025-08-29 19:32:29', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354040, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 19:32:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 19:32:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 19:32:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354044, 'Database Backup [database_backup_2025-08-29-19-32-33-v3-3-1.zip]', '2025-08-29 19:32:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354045, 'Invoice Status Updated [Invoice Number: INV-178/07/2025, From: Overdue To: Paid]', '2025-08-29 19:36:13', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354046, 'Payment Recorded [ID:137, Invoice Number: INV-178/07/2025, Total: $500.00]', '2025-08-29 19:36:13', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354047, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-08-29 19:36:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:55:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:55:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:55:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:12:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:12:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:12:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354933, 'Database Backup [database_backup_2025-08-31-00-00-04-v3-3-1.zip]', '2025-08-31 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:41:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:41:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:41:35', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:23:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:23:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:23:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355687, 'Database Backup [database_backup_2025-09-01-00-04-04-v3-3-1.zip]', '2025-09-01 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 03:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staff