#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=339874 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315744, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315748, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315752, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315756, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315760, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315764, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315768, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315772, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315776, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 04:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315780, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315784, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315788, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315792, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315796, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315800, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315804, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315808, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315812, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315816, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 05:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315820, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315824, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315828, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315832, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315836, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315840, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315844, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315848, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315852, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315856, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315860, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 06:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315864, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315868, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315872, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315876, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315880, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315884, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315888, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315892, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315896, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315900, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 07:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315904, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315908, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315912, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315916, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315920, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315924, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315928, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315932, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315936, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315940, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315944, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 08:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315948, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315952, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315956, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315960, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315964, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315968, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315972, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315976, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315980, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315984, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 09:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315988, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315992, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315996, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (315999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316000, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316004, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316008, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316012, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316016, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316020, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316024, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 10:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316028, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316032, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316036, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316040, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316044, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316048, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316052, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316056, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316060, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316064, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316068, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 11:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316072, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316076, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316080, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316084, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316088, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316092, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316096, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316100, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316104, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316108, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 12:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316112, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316116, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316120, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316124, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316128, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316132, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316136, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316140, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316144, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316148, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316152, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 13:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316156, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316160, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316164, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316168, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316172, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316176, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316180, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316184, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316188, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316192, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 14:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316196, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316200, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316204, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316208, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316212, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316216, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316220, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316224, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316228, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316232, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 15:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316236, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316240, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316244, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316248, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316252, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316256, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316260, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316264, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316268, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316272, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316276, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 16:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316280, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316284, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316288, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316292, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316296, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316300, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316304, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316308, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316312, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316316, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 17:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316320, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316324, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316328, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316332, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316336, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316340, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316344, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316348, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316352, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316356, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 18:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316360, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316364, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316368, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316372, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316376, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316380, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316384, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316388, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316392, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316396, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 19:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316400, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316404, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316408, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316412, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316416, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316420, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316424, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316428, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316432, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316436, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316440, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 20:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316444, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316448, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316452, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316456, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316460, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316464, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316468, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316472, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316476, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316480, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 21:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316484, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316488, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316492, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316496, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316500, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316504, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316508, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316512, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316516, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316520, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 22:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316524, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316528, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316532, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316536, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316540, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316544, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316548, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316552, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316556, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-29 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-29 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-29 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316560, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-29 23:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316564, 'Database Backup [database_backup_2025-06-30-00-00-03-v3-1-6.zip]', '2025-06-30 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316565, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316569, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316573, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316577, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316581, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316585, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316589, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316593, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316597, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316601, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316605, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 00:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316609, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316613, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316617, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316621, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316625, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316629, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316633, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316637, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316641, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316645, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 01:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316649, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316653, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316657, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316661, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316665, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316669, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316673, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316677, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316681, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 02:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 02:54:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 02:54:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316685, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 02:54:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316689, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316693, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316697, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316701, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316705, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316709, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316713, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316717, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316721, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316725, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316729, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 03:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316733, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316737, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316741, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316745, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316749, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316753, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316757, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316761, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316765, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316769, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 04:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316773, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316777, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316781, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316785, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316789, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316793, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316797, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316801, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:41:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316805, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:52:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:52:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316809, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:53:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 05:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 05:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 05:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316813, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 05:58:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:04:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:04:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316817, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:04:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316821, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:09:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316825, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:15:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316829, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316833, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:26:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316837, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:32:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:37:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:37:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:37:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316841, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:37:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316845, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316849, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:49:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 06:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 06:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 06:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316853, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 06:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:00:39', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:00:48', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316857, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316861, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:06:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316865, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:11:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316869, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:17:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316873, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:22:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:28:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:28:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316877, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:28:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316881, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:34:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316885, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:40:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316889, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316893, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316897, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 07:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316901, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316905, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316909, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316913, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316917, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316921, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316925, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316929, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316933, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316937, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 08:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316941, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316945, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316949, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316953, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316957, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316961, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316965, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316969, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316973, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316977, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 09:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316981, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316985, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316989, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316993, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316997, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (316999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317001, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317005, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317009, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317013, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317017, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:53:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 10:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 10:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 10:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317021, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 10:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317025, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317029, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317033, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317037, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317041, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317045, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317049, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317053, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317057, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317061, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 11:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317065, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317069, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317073, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317077, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317081, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317085, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317089, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317093, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317097, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317101, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 12:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317105, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317109, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317113, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317117, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317121, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317125, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317129, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317133, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317137, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317141, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:51:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317145, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 13:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317149, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317153, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317157, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317161, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317165, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317169, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317173, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317177, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317181, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317185, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 14:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317189, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317193, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317197, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317201, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317205, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317209, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317213, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317217, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317221, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317225, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317229, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 15:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317233, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317237, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317241, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317245, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317249, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317253, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317257, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317261, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317265, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317269, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 16:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317273, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317277, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317281, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317285, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317289, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317293, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317297, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317301, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:39:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317305, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317309, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317313, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 17:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317317, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317321, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317325, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317329, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317333, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317337, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317341, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317345, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317349, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317353, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 18:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317357, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 19:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317361, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 19:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 19:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 19:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 19:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317365, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 19:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 19:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 19:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 19:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317369, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 19:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317373, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 19:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317377, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 19:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317381, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 19:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317385, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 19:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317389, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 19:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317393, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 19:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 20:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 20:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 20:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317397, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 20:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317401, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 20:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 20:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 20:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 20:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317405, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 20:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317409, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 20:18:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 20:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 20:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 20:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317413, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 20:24:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317417, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 20:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317421, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 20:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317425, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 20:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317429, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 20:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 20:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 20:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 20:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317433, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 20:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 21:00:26', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 21:00:26', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 21:00:26', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317437, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 21:00:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317441, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 21:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317445, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 21:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317449, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 21:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317453, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 21:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317457, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 21:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317461, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 21:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317465, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 21:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317469, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 21:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317473, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 21:53:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 21:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 21:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 21:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317477, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 21:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 22:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 22:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 22:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317481, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 22:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 22:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 22:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 22:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317485, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 22:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317489, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 22:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317493, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 22:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317497, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 22:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317501, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 22:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317505, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 22:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317509, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 22:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317513, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 22:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317517, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 22:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 23:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 23:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 23:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317521, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 23:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 23:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 23:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 23:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317525, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 23:10:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317529, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 23:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317533, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 23:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317537, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 23:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 23:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 23:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 23:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317541, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 23:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317545, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 23:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317549, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 23:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317553, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 23:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-30 23:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-30 23:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-30 23:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317557, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-30 23:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 00:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 00:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 00:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317561, 'Database Backup [database_backup_2025-07-01-00-01-02-v3-1-6.zip]', '2025-07-01 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317562, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 00:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317566, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 00:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317570, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 00:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 00:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 00:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 00:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317574, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 00:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317578, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 00:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 00:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 00:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 00:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317582, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 00:29:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317586, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 00:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317590, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 00:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317594, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 00:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317598, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 00:53:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317602, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 00:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317606, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 01:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317610, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 01:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317614, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 01:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317618, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 01:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317622, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 01:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317626, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 01:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317630, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 01:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317634, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 01:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317638, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 01:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317642, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 01:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317646, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 02:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317650, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 02:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317654, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 02:15:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317658, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 02:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317662, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 02:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317666, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 02:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317670, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 02:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317674, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 02:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317678, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 02:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317682, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 02:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317686, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 03:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317690, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 03:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317694, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 03:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317698, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 03:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317702, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 03:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317706, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 03:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 03:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 03:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 03:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317710, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 03:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317714, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 03:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317718, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 03:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317722, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 03:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317726, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 03:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317730, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 04:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317734, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 04:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317738, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 04:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317742, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 04:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317746, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 04:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317750, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 04:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317754, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 04:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317758, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 04:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317762, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 04:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317766, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 04:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317770, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 05:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317774, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 05:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317778, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 05:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317782, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 05:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317786, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 05:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 05:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 05:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 05:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317790, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 05:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317794, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 05:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317798, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 05:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317802, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 05:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 05:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 05:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 05:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317806, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 05:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 05:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 05:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 05:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317810, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 05:56:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 06:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 06:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 06:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317814, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 06:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317818, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 06:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317822, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 06:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317826, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 06:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317830, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 06:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317834, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 06:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 06:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 06:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 06:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317838, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 06:37:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317842, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 06:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 06:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 06:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 06:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317846, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 06:49:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317850, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 06:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317854, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 07:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317858, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 07:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317862, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 07:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317866, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 07:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317870, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 07:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317874, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 07:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317878, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 07:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317882, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 07:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317886, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 07:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317890, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 07:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317894, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 07:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317898, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 08:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317902, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 08:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317906, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 08:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317910, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 08:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317914, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 08:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317918, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 08:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317922, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 08:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317926, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 08:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317930, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 08:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317934, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 08:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317938, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 09:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317942, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 09:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317946, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 09:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317950, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 09:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317954, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 09:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317958, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 09:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317962, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 09:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317966, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 09:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317970, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 09:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317974, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 09:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317978, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 09:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317982, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 10:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317986, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 10:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317990, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 10:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317994, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 10:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317998, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 10:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (317999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318002, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 10:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 10:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 10:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 10:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318006, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 10:40:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 10:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 10:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 10:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318010, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 10:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318014, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 10:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318018, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 10:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318022, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 11:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318026, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 11:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318030, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 11:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318034, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 11:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318038, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 11:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318042, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 11:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318046, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 11:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 11:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 11:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 11:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318050, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 11:45:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318054, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 11:51:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318058, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 11:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318062, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 12:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318066, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 12:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318070, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 12:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318074, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 12:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 12:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 12:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 12:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318078, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 12:27:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318082, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 12:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 12:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 12:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 12:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318086, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 12:38:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318090, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 12:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318094, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 12:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318098, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 12:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318102, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 13:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318106, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 13:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318110, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 13:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318114, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 13:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 13:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 13:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 13:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318118, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 13:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318122, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 13:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318126, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 13:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318130, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 13:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 13:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 13:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 13:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318134, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 13:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318138, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 13:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 14:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 14:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 14:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318142, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 14:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318146, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 14:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318150, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 14:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318154, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 14:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 14:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 14:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 14:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318158, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 14:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318162, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 14:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318166, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 14:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318170, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 14:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 14:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 14:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 14:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318174, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 14:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318178, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 14:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318182, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 14:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318186, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 15:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 15:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 15:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 15:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318190, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 15:09:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318194, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 15:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318198, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 15:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 15:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 15:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 15:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318202, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 15:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 15:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 15:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 15:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318206, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 15:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318210, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 15:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318214, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 15:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318218, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 15:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 15:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 15:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 15:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318222, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 15:53:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318226, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 15:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 16:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 16:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 16:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318230, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 16:05:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318234, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 16:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318238, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 16:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318242, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 16:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 16:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 16:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 16:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318246, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 16:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318250, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 16:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318254, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 16:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318258, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 16:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318262, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 16:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318266, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 16:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 17:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 17:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 17:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318270, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 17:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318274, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 17:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318278, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 17:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318282, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 17:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318286, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 17:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318290, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 17:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318294, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 17:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318298, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 17:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 17:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 17:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 17:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318302, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 17:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 17:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 17:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 17:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318306, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 17:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318310, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 18:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 18:05:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 18:05:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 18:05:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318314, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 18:05:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 18:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 18:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 18:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318318, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 18:11:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 18:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 18:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 18:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318322, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 18:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318326, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 18:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 18:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 18:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 18:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318330, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 18:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318334, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 18:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318338, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 18:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318342, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 18:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318346, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 18:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318350, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 18:58:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318354, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 19:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318358, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 19:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318362, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 19:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318366, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 19:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318370, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 19:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318374, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 19:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318378, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 19:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 19:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 19:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318382, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 19:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318386, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 19:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318390, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 19:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318394, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 19:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318398, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 20:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318402, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 20:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318406, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 20:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318410, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 20:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318414, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 20:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318418, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 20:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318422, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 20:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318426, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 20:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318430, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 20:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318434, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 20:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318438, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318442, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 21:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 21:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 21:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 21:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318446, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 21:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318450, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 21:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318454, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 21:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318458, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 21:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318462, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 21:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318466, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 21:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318470, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 21:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318474, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 21:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318478, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 22:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318482, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 22:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318486, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 22:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318490, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 22:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318494, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 22:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318498, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 22:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318502, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 22:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318506, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 22:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318510, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 22:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318514, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 22:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318518, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 22:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318522, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 23:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318526, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 23:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318530, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 23:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318534, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 23:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318538, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 23:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318542, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 23:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318546, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 23:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318550, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 23:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318554, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 23:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-01 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-01 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-01 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318558, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-01 23:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318562, 'Database Backup [database_backup_2025-07-02-00-04-03-v3-1-6.zip]', '2025-07-02 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318563, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 00:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318567, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 00:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318571, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 00:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318575, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 00:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318579, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 00:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318583, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 00:33:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318587, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 00:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318591, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 00:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318595, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 00:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318599, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 00:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318603, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 01:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318607, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 01:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318611, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 01:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318615, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 01:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318619, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 01:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318623, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 01:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318627, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 01:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318631, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 01:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318635, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 01:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318639, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 01:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 02:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 02:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 02:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318643, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 02:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318647, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 02:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318651, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 02:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318655, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 02:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318659, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 02:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318663, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 02:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318667, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 02:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318671, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 02:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318675, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 02:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318679, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 02:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318683, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 02:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318687, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 03:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318691, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 03:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318695, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 03:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318699, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 03:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318703, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 03:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318707, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 03:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318711, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 03:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318715, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 03:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318719, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 03:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318723, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 03:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318727, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 04:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318731, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 04:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318735, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 04:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318739, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 04:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318743, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 04:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318747, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 04:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318751, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 04:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318755, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 04:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318759, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 04:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318763, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 04:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318767, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 05:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318771, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 05:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318775, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 05:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318779, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 05:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318783, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 05:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318787, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 05:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318791, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 05:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318795, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 05:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318799, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 05:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318803, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 05:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318807, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 05:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318811, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 06:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318815, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 06:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318819, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 06:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318823, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 06:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318827, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 06:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318831, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 06:30:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318835, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 06:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318839, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 06:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318843, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 06:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318847, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 06:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318851, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 07:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318855, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 07:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318859, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 07:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318863, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 07:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318867, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 07:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318871, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 07:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318875, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 07:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318879, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 07:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318883, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 07:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318887, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 07:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318891, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 07:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318895, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 08:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318899, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 08:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318903, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 08:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318907, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 08:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318911, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 08:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318915, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 08:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318919, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 08:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318923, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 08:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318927, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 08:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318931, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 08:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318935, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 09:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318939, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 09:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318943, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 09:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318947, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 09:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318951, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 09:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318955, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 09:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318959, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 09:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318963, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 09:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318967, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 09:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318971, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 09:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318975, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 10:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318979, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 10:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 10:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 10:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318983, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 10:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318987, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 10:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318991, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 10:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318995, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 10:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (318999, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 10:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319003, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 10:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319007, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 10:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319011, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 10:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319015, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 10:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319019, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 11:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319023, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 11:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319027, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 11:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319031, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 11:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319035, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 11:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319039, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 11:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319043, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 11:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319047, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 11:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319051, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 11:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319055, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 11:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319059, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 12:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319063, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 12:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319067, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 12:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319071, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 12:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319075, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 12:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319079, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 12:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319083, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 12:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319087, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 12:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319091, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 12:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319095, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 12:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319099, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 13:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319103, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 13:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319107, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 13:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319111, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 13:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319115, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 13:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319119, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 13:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319123, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 13:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319127, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 13:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319131, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 13:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319135, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 13:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319139, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 13:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319143, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 14:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319147, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 14:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319151, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 14:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319155, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 14:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319159, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 14:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319163, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 14:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319167, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 14:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319171, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 14:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319175, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 14:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319179, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 14:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319183, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 15:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319187, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 15:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319191, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 15:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319195, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 15:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 15:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 15:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 15:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319199, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 15:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319203, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 15:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319207, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 15:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319211, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 15:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319215, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 15:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319219, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 15:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319223, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 16:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 16:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 16:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 16:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319227, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 16:07:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319231, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 16:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319235, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 16:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319239, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 16:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319243, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 16:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319247, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 16:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319251, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 16:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319255, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 16:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319259, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 16:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319263, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 16:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319267, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 17:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319271, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 17:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319275, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 17:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319279, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 17:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319283, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 17:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319287, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 17:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319291, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 17:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319295, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 17:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319299, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 17:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319303, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 17:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319307, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 18:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319311, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 18:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319315, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 18:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319319, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 18:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319323, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 18:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319327, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 18:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319331, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 18:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319335, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 18:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319339, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 18:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319343, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 18:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319347, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 19:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319351, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 19:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319355, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 19:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319359, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 19:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319363, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 19:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319367, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 19:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319371, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 19:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319375, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 19:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319379, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 19:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319383, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 19:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319387, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 19:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319391, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 20:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319395, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 20:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319399, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 20:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319403, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 20:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319407, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 20:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319411, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 20:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319415, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 20:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319419, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 20:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319423, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 20:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319427, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 20:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319431, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319435, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 21:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319439, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 21:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319443, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 21:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319447, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 21:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319451, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 21:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 21:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319455, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 21:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319459, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 21:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319463, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 21:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319467, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 21:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319471, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 21:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319475, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 22:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319479, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 22:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319483, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 22:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319487, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 22:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319491, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 22:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319495, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 22:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319499, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 22:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319503, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 22:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319507, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 22:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319511, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 22:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319515, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 23:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319519, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 23:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319523, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 23:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319527, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 23:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319531, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 23:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319535, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 23:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319539, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 23:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319543, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 23:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319547, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 23:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-02 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-02 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-02 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319551, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-02 23:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319555, 'Database Backup [database_backup_2025-07-03-00-00-04-v3-1-6.zip]', '2025-07-03 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319556, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 00:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319560, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 00:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319564, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 00:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319568, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 00:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319572, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 00:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319576, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 00:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319580, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 00:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319584, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 00:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319588, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 00:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319592, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 00:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319596, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 00:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319600, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 01:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319604, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 01:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319608, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 01:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319612, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 01:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319616, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 01:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319620, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 01:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319624, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 01:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319628, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 01:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319632, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 01:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319636, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 01:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319640, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 02:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319644, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 02:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319648, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 02:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319652, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 02:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319656, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 02:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319660, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 02:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319664, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 02:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319668, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 02:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319672, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 02:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319676, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 02:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319680, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 02:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319684, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 03:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319688, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 03:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319692, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 03:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319696, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 03:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319700, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 03:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319704, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 03:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319708, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 03:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319712, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 03:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319716, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 03:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319720, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 03:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319724, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319728, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319732, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319736, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319740, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319744, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319748, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319752, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319756, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319760, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319764, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 04:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319768, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319772, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319776, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319780, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319784, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319788, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319792, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319796, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319800, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319804, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 05:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319808, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319812, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319816, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319820, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319824, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319828, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319832, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319836, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319840, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319844, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319848, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 06:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319852, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319856, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319860, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319864, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319868, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319872, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319876, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319880, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319884, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:50:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319888, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 07:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319892, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319896, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319900, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319904, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319908, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319912, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319916, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319920, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319924, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319928, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 08:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319932, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319936, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319940, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319944, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319948, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319952, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319956, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319960, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319964, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319968, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 09:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319972, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319976, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319980, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319984, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319988, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319992, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319996, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (319999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320000, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320004, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320008, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 10:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320012, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320016, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320020, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320024, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320028, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320032, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320036, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320040, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320044, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320048, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320052, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 11:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320056, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320060, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320064, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320068, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320072, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320076, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320080, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320084, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320088, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320092, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 12:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320096, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320100, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320104, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320108, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320112, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320116, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320120, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320124, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320128, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320132, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 13:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320136, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320140, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320144, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320148, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320152, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320156, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320160, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320164, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320168, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320172, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320176, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 14:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320180, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320184, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320188, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320192, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320196, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320200, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:33:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320204, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320208, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320212, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320216, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 15:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320220, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320224, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320228, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320232, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320236, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320240, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320244, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320248, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320252, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320256, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 16:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320260, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320264, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320268, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320272, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320276, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320280, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320284, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320288, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320292, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320296, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320300, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 17:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320304, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320308, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320312, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320316, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320320, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320324, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-03 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-03 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320328, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-03 18:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-03 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (320330, 'Failed to