#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=98899 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (74999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75389, 'Database Backup [database_backup_2024-09-05-00-04-03-v3-1-6.zip]', '2024-09-05 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75933, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.170]', '2024-09-05 16:24:52', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (75999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-05 23:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-05 23:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-05 23:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76210, 'Database Backup [database_backup_2024-09-06-00-05-02-v3-1-6.zip]', '2024-09-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 01:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 01:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 01:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76676, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.157]', '2024-09-06 14:21:47', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 17:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 17:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 17:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 17:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 17:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 17:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 18:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 18:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 18:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76824, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 200.7.90.157]', '2024-09-06 18:50:01', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76825, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 200.7.90.157]', '2024-09-06 18:50:46', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76829, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: No, IP: 200.7.90.157]', '2024-09-06 18:51:15', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76830, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: No, IP: 200.7.90.157]', '2024-09-06 18:51:28', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76831, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 200.7.90.157]', '2024-09-06 18:51:57', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76832, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 200.7.90.157]', '2024-09-06 18:52:28', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76833, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.157]', '2024-09-06 18:52:45', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 20:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 20:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 20:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76909, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-09-06 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (76999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-06 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-06 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-06 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77012, 'Database Backup [database_backup_2024-09-07-00-05-03-v3-1-6.zip]', '2024-09-07 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 03:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 03:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 03:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 04:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 04:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 04:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 04:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 04:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 04:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 05:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 12:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 12:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 12:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 16:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 16:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 16:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 18:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 18:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 18:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 19:21:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 19:21:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 19:21:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 19:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 19:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 19:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 19:32:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 19:32:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 19:32:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 19:38:26', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 19:38:26', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 19:38:26', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 19:43:48', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 19:43:48', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 19:43:48', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 19:49:55', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 19:49:55', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 19:49:55', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 19:56:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 19:56:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 19:55:57', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 19:56:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 19:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 19:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 20:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 20:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 20:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 20:07:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 20:07:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 20:07:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 20:12:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 20:12:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 20:12:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 20:17:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 20:17:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 20:17:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 20:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 20:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 20:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 20:23:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 20:23:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 20:23:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 20:28:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 20:28:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 20:28:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 20:28:44', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 20:28:48', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 20:28:51', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 20:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 20:39:36', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 20:39:36', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 20:39:36', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 20:45:46', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 20:45:46', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 20:45:46', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 20:52:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 20:52:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 20:52:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 20:57:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 20:57:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 20:57:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 21:03:59', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 21:03:59', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 21:03:59', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 21:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 21:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 21:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 21:10:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 21:10:26', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 21:10:26', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 21:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 21:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 21:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 21:15:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 21:15:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 21:15:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 21:22:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 21:22:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 21:22:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 21:27:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 21:27:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 21:27:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 21:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 21:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 21:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 21:33:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 21:33:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 21:33:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 22:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 22:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 22:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 22:22:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 22:22:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 22:22:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 22:28:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 22:28:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 22:28:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 22:28:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 22:28:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 22:28:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 22:33:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 22:33:26', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 22:33:26', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 22:38:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 22:38:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 22:38:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 22:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 22:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 22:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 22:49:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 22:49:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 22:49:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 22:55:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 22:55:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 22:55:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 22:55:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 22:55:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 22:55:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 23:01:37', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 23:01:37', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 23:01:37', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 23:01:40', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 23:01:40', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 23:01:40', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 23:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 23:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 23:12:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 23:12:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 23:12:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 23:17:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 23:17:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 23:17:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 23:22:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 23:22:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 23:22:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-07 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-07 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-07 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77865, 'Database Backup [database_backup_2024-09-08-00-01-03-v3-1-6.zip]', '2024-09-08 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 00:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 00:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 00:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 02:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 02:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 02:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78508, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.179]', '2024-09-08 19:13:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78668, 'Database Backup [database_backup_2024-09-09-00-00-04-v3-1-6.zip]', '2024-09-09 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79149, 'Failed to connect to IMAP auto importing tickets for 