#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=155318 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132224, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-11-14 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132225, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Overdue Notice]', '2024-11-14 21:04:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:04:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:04:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:04:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132331, 'Database Backup [database_backup_2024-11-15-00-05-02-v3-1-6.zip]', '2024-11-15 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 18:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 18:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 18:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 18:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 18:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 18:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 23:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 23:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 23:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133118, 'Database Backup [database_backup_2024-11-16-00-01-03-v3-1-6.zip]', '2024-11-16 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 02:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 02:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 02:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 04:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 04:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 04:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 07:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 07:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 07:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 08:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 08:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 08:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 14:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 14:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 14:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 15:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 15:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 15:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 17:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 17:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 17:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 19:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 19:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 19:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 20:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 20:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 20:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 21:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 21:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 21:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 23:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 23:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 23:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 23:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 23:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 23:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-16 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-16 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-16 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133914, 'Database Backup [database_backup_2024-11-17-00-00-04-v3-1-6.zip]', '2024-11-17 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (133999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 07:23:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 07:23:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 07:23:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 09:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 09:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 09:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 10:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 10:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 10:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 12:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 12:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 12:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 15:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 15:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 15:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 17:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 17:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 17:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 19:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 19:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 19:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134608, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-11-17 21:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134609, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Overdue Notice]', '2024-11-17 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 21:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 22:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 22:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 22:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-17 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-17 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-17 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134709, 'Database Backup [database_backup_2024-11-18-00-00-04-v3-1-6.zip]', '2024-11-18 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 00:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:44:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:44:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:44:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135508, 'Database Backup [database_backup_2024-11-19-00-00-05-v3-1-6.zip]', '2024-11-19 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:00:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:00:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:11:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:11:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:11:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:27:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:27:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:27:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:27:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:27:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:27:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:33:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:33:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:33:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` 