#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=215986 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191822, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-28 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191823, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-28 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191923, 'Database Backup [database_backup_2025-01-29-00-02-02-v3-1-6.zip]', '2025-01-29 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192521, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-01-29 18:05:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192528, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-01-29 18:16:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192532, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-01-29 18:21:35', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192536, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-01-29 18:27:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192546, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-01-29 18:45:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192553, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-01-29 18:56:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192626, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-29 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192726, 'Database Backup [database_backup_2025-01-30-00-01-02-v3-1-6.zip]', '2025-01-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 02:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 02:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 02:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 11:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 11:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 11:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 11:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-30 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-30 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-30 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193531, 'Database Backup [database_backup_2025-01-31-00-00-02-v3-1-6.zip]', '2025-01-31 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 03:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 03:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 03:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (193999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194213, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-31 21:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194214, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-31 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-31 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-31 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-31 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194317, 'Database Backup [database_backup_2025-02-01-00-02-02-v3-1-6.zip]', '2025-02-01 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 04:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 04:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 04:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 06:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 06:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 06:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 09:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 09:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 09:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 15:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 15:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 15:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 18:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 18:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 18:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 18:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 18:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 18:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 18:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 18:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 18:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (194999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195008, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-01 21:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-01 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-01 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-01 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195111, 'Database Backup [database_backup_2025-02-02-00-04-03-v3-1-6.zip]', '2025-02-02 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 04:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 04:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 04:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 04:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 04:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 04:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 04:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 09:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 09:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 09:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 10:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 13:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 13:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 13:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 16:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 16:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 16:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-02 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-02 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (195697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-02 18:00:05', '[CRON]');
INSERT INTO `tb